/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.action;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.FilterableWeightedList;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Triple;

public class BlockActions {
    public static void register() {
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("and"), new SerializableData().add("actions", SerializableDataType.BLOCK_ACTIONS), (data, block) -> ((List)data.get("actions")).forEach(e -> e.accept(block))));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("chance"), new SerializableData().add("action", SerializableDataType.BLOCK_ACTION).add("chance", SerializableDataType.FLOAT), (data, block) -> {
            Random random = new Random();
            if (random.nextFloat() < data.getFloat("chance")) {
                ((ActionFactory.Instance)data.get("action")).accept(block);
            }
        }));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("if_else"), new SerializableData().add("condition", SerializableDataType.BLOCK_CONDITION).add("if_action", SerializableDataType.BLOCK_ACTION).add("else_action", SerializableDataType.BLOCK_ACTION, null), (data, block) -> {
            if (((ConditionFactory.Instance)data.get("condition")).test(new CachedBlockInfo((IWorldReader)block.getLeft(), (BlockPos)block.getMiddle(), true))) {
                ((ActionFactory.Instance)data.get("if_action")).accept(block);
            } else if (data.isPresent("else_action")) {
                ((ActionFactory.Instance)data.get("else_action")).accept(block);
            }
        }));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("choice"), new SerializableData().add("actions", SerializableDataType.weightedList(SerializableDataType.BLOCK_ACTION)), (data, block) -> {
            FilterableWeightedList actionList = (FilterableWeightedList)((Object)((Object)data.get("actions")));
            ActionFactory.Instance action = (ActionFactory.Instance)actionList.func_226318_b_(new Random());
            action.accept(block);
        }));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("offset"), new SerializableData().add("action", SerializableDataType.BLOCK_ACTION).add("x", SerializableDataType.INT, 0).add("y", SerializableDataType.INT, 0).add("z", SerializableDataType.INT, 0), (data, block) -> ((ActionFactory.Instance)data.get("action")).accept(Triple.of((Object)((World)block.getLeft()), (Object)((BlockPos)block.getMiddle()).func_177982_a(data.getInt("x"), data.getInt("y"), data.getInt("z")), (Object)((Direction)block.getRight())))));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("set_block"), new SerializableData().add("block", SerializableDataType.BLOCK), (data, block) -> ((World)block.getLeft()).func_175656_a((BlockPos)block.getMiddle(), ((Block)data.get("block")).func_176223_P())));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("add_block"), new SerializableData().add("block", SerializableDataType.BLOCK), (data, block) -> ((World)block.getLeft()).func_175656_a(((BlockPos)block.getMiddle()).func_177972_a((Direction)block.getRight()), ((Block)data.get("block")).func_176223_P())));
        BlockActions.register(new ActionFactory<Triple<World, BlockPos, Direction>>(Origins.identifier("execute_command"), new SerializableData().add("command", SerializableDataType.STRING).add("permission_level", SerializableDataType.INT, 4), (data, block) -> {
            MinecraftServer server = ((World)block.getLeft()).func_73046_m();
            if (server != null) {
                String blockName = ((World)block.getLeft()).func_180495_p((BlockPos)block.getMiddle()).func_177230_c().func_149739_a();
                CommandSource source = new CommandSource(ICommandSource.field_213139_a_, new Vector3d((double)((BlockPos)block.getMiddle()).func_177958_n() + 0.5, (double)((BlockPos)block.getMiddle()).func_177956_o() + 0.5, (double)((BlockPos)block.getMiddle()).func_177952_p() + 0.5), new Vector2f(0.0f, 0.0f), (ServerWorld)block.getLeft(), data.getInt("permission_level"), blockName, (ITextComponent)new TranslationTextComponent(blockName), server, null);
                server.func_195571_aL().func_197059_a(source, data.getString("command"));
            }
        }));
    }

    private static void register(ActionFactory<Triple<World, BlockPos, Direction>> actionFactory) {
        ModRegistriesArchitectury.BLOCK_ACTION.register(actionFactory.getSerializerId(), () -> actionFactory);
    }
}

